const { DataTypes } = require('sequelize');
const db = require('../config/database');
const Users = require('./UserModel');

const Categories = db.define('categories', {
    id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true
    },
    name: {
        type: DataTypes.STRING,
        allowNull: false
    },
    type: {
        type: DataTypes.ENUM('INCOME', 'EXPENSE'),
        allowNull: false
    },
    budget_limit: {
        type: DataTypes.DECIMAL(15, 2),
        defaultValue: 0
    },
    user_id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        references: {
            model: Users,
            key: 'id'
        }
    }
}, {
    freezeTableName: true
});

Users.hasMany(Categories, { foreignKey: 'user_id'});
Categories.belongsTo(Users, { foreignKey: 'user_id'});

module.exports = Categories;