const { DataTypes } = require('sequelize');
const db = require('../config/database');
const Users = require('./UserModel');
const Accounts = require('./AccountModel');
const SavingGoal = require('./SavingGoalModel');

const SavingTransaction = db.define('saving_transactions', {
    id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true
    },
    user_id: {
        type: DataTypes.INTEGER,
        allowNull: false
    },
    saving_goal_id: {
        type: DataTypes.INTEGER,
        allowNull: false
    },
    account_id: {
        type: DataTypes.INTEGER,
        allowNull: false
    },
    amount: {
        type: DataTypes.DECIMAL(15, 2),
        allowNull: false
    },
    date: {
        type: DataTypes.DATEONLY,
        allowNull: false
    },
    type: {
        type: DataTypes.ENUM('DEPOSIT', 'WITHDRAW'),
        allowNull: false
    },
    note: {
        type: DataTypes.STRING,
        allowNull: true
    }
}, {
    freezeTableName: true
});

SavingTransaction.belongsTo(Users, { foreignKey: 'user_id' });
SavingTransaction.belongsTo(Accounts, { foreignKey: 'account_id' });
SavingTransaction.belongsTo(SavingGoal, { foreignKey: 'saving_goal_id' });

module.exports = SavingTransaction;
