const { DataTypes } = require('sequelize');
const db = require('../config/database');
const Users = require('./UserModel');

const SubAccount = db.define('sub_accounts', {
    id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true
    },
    owner_user_id: {
        type: DataTypes.INTEGER,
        allowNull: false
    },
    sub_user_id: {
        type: DataTypes.INTEGER,
        allowNull: false
    }
}, {
    freezeTableName: true
});

SubAccount.belongsTo(Users, {
    as: 'owner',
    foreignKey: 'owner_user_id'
});

SubAccount.belongsTo(Users, {
    as: 'subUser',
    foreignKey: 'sub_user_id'
});

module.exports = SubAccount;
