const express = require('express');
const { getAccounts, createAccount, updateAccount, deleteAccount } = require('../controllers/AccountController');
const { verifyToken } = require('../middleware/VerifyToken');
const { getAccountReport } = require('../controllers/AccountReportController');

const router = express.Router();

router.get('/accounts', verifyToken, getAccounts);
router.post('/accounts', verifyToken, createAccount);
router.patch('/accounts/:id', verifyToken, updateAccount); // Edit
router.delete('/accounts/:id', verifyToken, deleteAccount); // Hapus
router.get('/accounts/:id/report', verifyToken, getAccountReport);

module.exports = router;