const express = require('express');
const { getCategories, createCategory, updateCategory, deleteCategory } = require('../controllers/CategoryController');
const { verifyToken } = require('../middleware/VerifyToken');

const router = express.Router();

router.get('/categories', verifyToken, getCategories);
router.post('/categories', verifyToken, createCategory);
router.patch('/categories/:id', verifyToken, updateCategory);
router.delete('/categories/:id', verifyToken, deleteCategory);

module.exports = router;