const express = require('express');
const {
    getSubAccounts,
    createSubAccount,
    updateSubAccount,
    deactivateSubAccount
} = require('../controllers/SubAccountController');
const { verifyToken } = require('../middleware/VerifyToken');

const router = express.Router();

// LIST semua sub-account milik user utama
router.get('/sub-accounts', verifyToken, getSubAccounts);

// CREATE sub-account baru
router.post('/sub-accounts', verifyToken, createSubAccount);

// UPDATE sub-account (nama, is_active)
router.patch('/sub-accounts/:id', verifyToken, updateSubAccount);

// DEACTIVATE sub-account
router.delete('/sub-accounts/:id', verifyToken, deactivateSubAccount);

module.exports = router;
